// canvasプラグイン
// ティラノスクリプトにタグを追加するためのプログラムです。

// 使う変数の定義（同名の変数を他で使用するとバグが発生する可能性があります。）
canvas_plugin_loaded_image = {};
canvas_plugin_loaded_image_number = {};
canvas_plugin_all_image_number = {};

(function(){
	// ■　[canvas]タグ			【キャンバスを設置する】
	// 設置したキャンバスは普通にfreeで撤去したりanimで動かしたりできます。
	// ・layer		：●キャンバスを設置するレイヤー（baseは不可）
	// ・page		：キャンバスを設置するページ（fore/back）
	// ・visible	：キャンバスを表示するか否か
	// ・top		：キャンバスを設置する位置（y）
	// ・left		：キャンバスを設置する位置（x）
	// ・x			：キャンバスを設置する位置（x）＝left
	// ・y			：キャンバスを設置する位置（y）＝top
	// ・width		：キャンバスのサイズ（横）
	// ・heigth		：キャンバスのサイズ（縦）
	// ・name		：キャンバスの名前
	// ・zindex		：キャンバスの重ね順
	// ・opacity	：キャンバスの不透明度(0～1の実数)
	// ・id			：キャンバスのID
	var canvas = {
		vital : ["layer"],
		pm : {
			"layer" : "",
			"page" : "fore",
			"visible" : "",
			"top" : "",
			"left" : "",
			"x" : "",
			"y" : "",
			"width" : "200",
			"height" : "200",
			"name" : "",
			"zindex" : "1",
			"opacity" : "1",
			"id" : ""
		},
		start : function(pm) {
			
			if(pm.layer != "base"){
				
				// このあたりは[image]タグを参考に記述
				var layer_new_style = {};
				if(pm.visible == "true" && pm.page == "fore") {
					layer_new_style.display = "block";
				}
				this.kag.setStyles(this.kag.layer.getLayer(pm.layer, pm.page), layer_new_style);
				
				// キャンバスタグのオブジェクトをつくる
				var canvas_obj = $("<canvas />");
				canvas_obj.attr("width", pm.width);
				canvas_obj.attr("height", pm.height);
				
				if(pm.id != ""){
					canvas_obj.attr("id", pm.id);
				}
				
				canvas_obj.css("position","absolute");
				canvas_obj.css("top", pm.top+"px");
				canvas_obj.css("left", pm.left+"px");
				if(pm.x != ""){
					canvas_obj.css("left", pm.x+"px");
				}
				if(pm.y != ""){
					canvas_obj.css("top", pm.y+"px");
				}
				if(pm.zindex != ""){
					canvas_obj.css("z-index", parseInt(pm.zindex));
				}
				if(pm.visible == "false"){
					canvas_obj.css("visibility","hidden");
				}else{
					canvas_obj.css("visibility","visible");
				}
				if(pm.opacity != ""){
					canvas_obj.css("opacity",parseFloat(pm.opacity));
				}
				
				// オブジェクトにクラス名をセット
				$.setName(canvas_obj, pm.name);
				
				this.kag.layer.getLayer(pm.layer, pm.page).append(canvas_obj);
                this.kag.ftag.nextOrder();
				
			} else {
				// baseレイヤの場合
				
				alert("canvasタグのlayerにbaseは設定できません");
				
				this.kag.ftag.nextOrder();
				
			}
			
		}
	};

	// ■　[canvas_drawimage]タグ		【キャンバスに画像を描画する】
	// 事前にcanvas_loadimageで画像データを読み込んでおく必要があります。
	// ・name		：画像を描画するキャンバスの名前（複数ある場合は該当する全てのキャンバスに描画します）
	// ・storage	：●画像ファイル名（canvas_laodimageで読み込み済みの「fgimageフォルダ内の画像」のみ対応）
	// ・x			：画像を描画するキャンバス内の位置(x)
	// ・y			：画像を描画するキャンバス内の位置(y)
	// ・width		：描画する幅
	// ・height		：描画する高さ
	// ・cutx		：描画する画像の切り出す位置(x)
	// ・cuty		：描画する画像の切り出す位置(y)
	// ・cutwidth	：描画する画像の切り出す幅
	// ・cutheight	：描画する画像の切り出す高さ
	// ・id			：画像を描画するキャンバスのid
	// ・coma		：読み込む画像の切り出す番号（描画する画像をcutwidthとcutheightで割って、左上から右下にかけて順に番号を振った場合の番号）
	var canvas_drawimage = {
		vital : ["storage"],
		pm : {
			"name" : "",
			"storage" : "",
			"x" : "0",
			"y" : "0",
			"width" : "100",
			"height" : "100",
			"cutx" : "",
			"cuty" : "",
			"cutwidth" : "",
			"cutheight" : "",
			"id" : "",
			"coma" : ""
		},
		start : function(pm){
			if(canvas_plugin_loaded_image[pm.storage]){
				if(pm.coma != ""){
					try{
						var imagew = canvas_plugin_loaded_image[pm.storage].width;
						var imageh = canvas_plugin_loaded_image[pm.storage].height;
						
						var cntx = Math.floor(imagew/pm.cutwidth);
						
						var coma = Math.floor(pm.coma);
						
						pm.cutx = coma%cntx*pm.width;
						pm.cuty = Math.floor(coma/cntx)*pm.height;
						
					}catch(e){
					}
				}
				
				if(pm.name != ""){
					var cvs = document.getElementsByClassName(pm.name);
					if(!pm.cutwidth){
						for(var i in cvs){
							try{
								var ctx = cvs[i].getContext("2d");
								ctx.drawImage(canvas_plugin_loaded_image[pm.storage],Math.floor(pm.x),Math.floor(pm.y),Math.floor(pm.width),Math.floor(pm.height));
							}catch(e){
							
							}
						}
					}else{
						for(var i in cvs){
							try{
								var ctx = cvs[i].getContext("2d");
								ctx.drawImage(canvas_plugin_loaded_image[pm.storage],Math.floor(pm.cutx),Math.floor(pm.cuty),Math.floor(pm.cutwidth),Math.floor(pm.cutheight),Math.floor(pm.x),Math.floor(pm.y),Math.floor(pm.width),Math.floor(pm.height));
							}catch(e){
							
							}
						}			
					}
				}else if(pm.id != ""){
					var cvs = document.getElementById(pm.id);
					if(!pm.cutwidth){
						var ctx = cvs.getContext("2d");
						ctx.drawImage(canvas_plugin_loaded_image[pm.storage],Math.floor(pm.x),Math.floor(pm.y),Math.floor(pm.width),Math.floor(pm.height));
					}else{
						var ctx = cvs.getContext("2d");
						ctx.drawImage(canvas_plugin_loaded_image[pm.storage],Math.floor(pm.cutx),Math.floor(pm.cuty),Math.floor(pm.cutwidth),Math.floor(pm.cutheight),Math.floor(pm.x),Math.floor(pm.y),Math.floor(pm.width),Math.floor(pm.height));
					}
				}
			}
			
			this.kag.ftag.nextOrder();
		}
	}

	// ■　[canvas_loadimage]タグ		【canvasタグ用の画像データを読み込む】
	// canvasに描画する画像データを読み込みます。
	// 読み込むまでwaitします。
	// ・storage	：●読み込む画像ファイル名（fgimage内の画像である必要あり）　カンマ(,)で区切ることで同時に読み込めます。
	// ・slot		：このタグを何度も使う場合は、slotにそれぞれ固有の名前をつけておくとよい…かも？
	var canvas_loadimage = {
		vital : ["storage"],
		pm : {
			"storage" : "",
			"slot" : "default"
		},
		start : function(pm){
			this.kag.weaklyStop();
			var that = this;
			var urls = pm.storage.split(",");
			
			canvas_plugin_loaded_image_number[pm.slot] = 0;
			canvas_plugin_all_image_number[pm.slot] = urls.length;
			
			for(var i=0; i<urls.length; i++){
				if(canvas_plugin_loaded_image[urls[i]]){
					canvas_plugin_loaded_image_number[pm.slot]++;
					if(canvas_plugin_loaded_image_number[pm.slot] >= canvas_plugin_all_image_number[pm.slot]){
						that.kag.cancelWeakStop();
	                    that.kag.ftag.nextOrder();
					}
				}else{
					canvas_plugin_loaded_image[urls[i]] = new Image;
					canvas_plugin_loaded_image[urls[i]].src = "./data/fgimage/" + urls[i];
					canvas_plugin_loaded_image[urls[i]].onload = function(){
						canvas_plugin_loaded_image_number[pm.slot]++;
						if(canvas_plugin_loaded_image_number[pm.slot] >= canvas_plugin_all_image_number[pm.slot]){
							that.kag.cancelWeakStop();
	                        that.kag.ftag.nextOrder();
						}
					}
				}
			}
			
			
		}
	}
	
	// ■　[canvas_clearrect]タグ		【キャンバスの描画をクリアする】
	// 指定したキャンバスの描画をクリアします。
	// ・name		：該当するnameのキャンバスの描画を全てクリアします。
	// ・id			：該当するidのキャンバスの描画をクリアします。
	var canvas_clearrect = {
		vital : [],
		pm : {
			"name" : "",
			"id" : ""
		},
		start : function(pm){
			if(pm.name != ""){
				var cvs = document.getElementsByClassName(pm.name);
				for(var i in cvs){
					try{
						var ctx = cvs[i].getContext("2d");
						var cw = cvs[i].width;
						var ch = cvs[i].height
						ctx.clearRect(0,0,cw,ch);
					}catch(e){
					
					}
				}
			}else if(pm.id != ""){
				try{
					var cvs = document.getElementById(pm.id);
					var ctx = cvs.getContext("2d");
					var cw = cvs.width;
					var ch = cvs.height
					ctx.clearRect(0,0,cw,ch);
				}catch(e){
				}
				
			}
			
			this.kag.ftag.nextOrder();
		}
	}	
	
	// ■　[canvas_delimage]タグ		【読み込み済みのcanvasタグ用画像データを全て削除する】
	var canvas_delimage = {
		vital : [],
		pm : {},
		start : function(pm){
			canvas_plugin_loaded_image = {};
			canvas_plugin_loaded_image_number = {};
			canvas_plugin_all_image_number = {};
			this.kag.ftag.nextOrder();
		
		}
	}

	// ■　[canvas_alldel]タグ		【全てのキャンバスを削除する】
	var canvas_alldel = {
		vital : [],
		pm : {},
		start : function(pm){
			// キャンバス全部取得して削除
			var canvasAll = document.getElementsByTagName("canvas");
			var nnn = canvasAll.length;
			for(var i=0; i<nnn; i++){
				canvasAll[0].remove();
			}
			
			this.kag.ftag.nextOrder();
		}
	}
	
	// ■　[canvas_select_delimage]タグ		【読み込み済みのcanvasタグ用画像データを一部削除する】
	// canvasに描画する画像データを一部削除します。
	// ・storage	：●削除する画像ファイル名（fgimage内の画像である必要あり）　カンマ(,)で区切ることで同時に削除できます。
	var canvas_select_delimage = {
		vital : ["storage"],
		pm : {
			"storage" : ""
		},
		start : function(pm){
			var that = this;
			var urls = pm.storage.split(",");
			
			for(var i=0; i<urls.length; i++){
				delete canvas_plugin_loaded_image[urls[i]];
			}
			
			that.kag.ftag.nextOrder();
		}
	}
	
	// タグとして割り当て
	TYRANO.kag.ftag.master_tag.canvas = object(canvas);
	TYRANO.kag.ftag.master_tag.canvas.kag = TYRANO.kag;
	
	TYRANO.kag.ftag.master_tag.canvas_drawimage = object(canvas_drawimage);
	TYRANO.kag.ftag.master_tag.canvas_drawimage.kag = TYRANO.kag;
	
	TYRANO.kag.ftag.master_tag.canvas_loadimage = object(canvas_loadimage);
	TYRANO.kag.ftag.master_tag.canvas_loadimage.kag = TYRANO.kag;
	
	TYRANO.kag.ftag.master_tag.canvas_clearrect = object(canvas_clearrect);
	TYRANO.kag.ftag.master_tag.canvas_clearrect.kag = TYRANO.kag;
	
	TYRANO.kag.ftag.master_tag.canvas_delimage = object(canvas_delimage);
	TYRANO.kag.ftag.master_tag.canvas_delimage.kag = TYRANO.kag;
	
	TYRANO.kag.ftag.master_tag.canvas_alldel = object(canvas_alldel);
	TYRANO.kag.ftag.master_tag.canvas_alldel.kag = TYRANO.kag;
	
	TYRANO.kag.ftag.master_tag.canvas_select_delimage = object(canvas_select_delimage);
	TYRANO.kag.ftag.master_tag.canvas_select_delimage.kag = TYRANO.kag;
	
})();
